using Radzen;
using Net8Auto.Server.Components;
using Microsoft.EntityFrameworkCore;
using Microsoft.OData.ModelBuilder;
using Microsoft.AspNetCore.OData;

var builder = WebApplication.CreateBuilder(args);
// Add services to the container.
builder.Services.AddRazorComponents().AddInteractiveServerComponents().AddInteractiveWebAssemblyComponents();
builder.Services.AddControllers();
builder.Services.AddRadzenComponents();
builder.Services.AddHttpClient();
builder.Services.AddScoped<Net8Auto.Server.RadzenSampleService>();
builder.Services.AddDbContext<Net8Auto.Server.Data.RadzenSampleContext>(options =>
{
    options.UseSqlServer(builder.Configuration.GetConnectionString("RadzenSampleConnection"));
});
builder.Services.AddControllers().AddOData(opt =>
{
    var oDataBuilderRadzenSample = new ODataConventionModelBuilder();
    oDataBuilderRadzenSample.EntitySet<Net8Auto.Server.Models.RadzenSample.OrderDetail>("OrderDetails");
    oDataBuilderRadzenSample.EntitySet<Net8Auto.Server.Models.RadzenSample.Order>("Orders");
    oDataBuilderRadzenSample.EntitySet<Net8Auto.Server.Models.RadzenSample.Product>("Products");
    opt.AddRouteComponents("odata/RadzenSample", oDataBuilderRadzenSample.GetEdmModel()).Count().Filter().OrderBy().Expand().Select().SetMaxTop(null).TimeZone = TimeZoneInfo.Utc;
});
builder.Services.AddScoped<Net8Auto.Client.RadzenSampleService>();
var app = builder.Build();
// Configure the HTTP request pipeline.
if (app.Environment.IsDevelopment())
{
    app.UseWebAssemblyDebugging();
}
else
{
    app.UseExceptionHandler("/Error", createScopeForErrors: true);
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.UseHttpsRedirection();
app.MapControllers();
app.UseStaticFiles();
app.UseAntiforgery();
app.MapRazorComponents<App>().AddInteractiveServerRenderMode().AddInteractiveWebAssemblyRenderMode().AddAdditionalAssemblies(typeof(Net8Auto.Client._Imports).Assembly);
app.Run();