using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Net8Auto.Server.Models.RadzenSample
{
    [Table("Products", Schema = "dbo")]
    public partial class Product
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public int Id { get; set; }

        [Required]
        public string ProductName { get; set; }

        [Required]
        public decimal ProductPrice { get; set; }

        [Required]
        public string ProductPicture { get; set; }

        public ICollection<OrderDetail> OrderDetails { get; set; }

        public NetTopologySuite.Geometries.Point Location { get; set; }
    }
}