using System;
using System.Linq;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;
using Net8Auto.Server.Models.RadzenSample;

namespace Net8Auto.Server.Data
{
    public partial class RadzenSampleContext : DbContext
    {
        public RadzenSampleContext()
        {
        }

        public RadzenSampleContext(DbContextOptions<RadzenSampleContext> options) : base(options)
        {
        }

        partial void OnModelBuilding(ModelBuilder builder);

        protected override void OnModelCreating(ModelBuilder builder)
        {
            base.OnModelCreating(builder);

            builder.Entity<Net8Auto.Server.Models.RadzenSample.OrderDetail>()
              .HasOne(i => i.Order)
              .WithMany(i => i.OrderDetails)
              .HasForeignKey(i => i.OrderId)
              .HasPrincipalKey(i => i.Id);

            builder.Entity<Net8Auto.Server.Models.RadzenSample.OrderDetail>()
              .HasOne(i => i.Product)
              .WithMany(i => i.OrderDetails)
              .HasForeignKey(i => i.ProductId)
              .HasPrincipalKey(i => i.Id);
            this.OnModelBuilding(builder);
        }

        public DbSet<Net8Auto.Server.Models.RadzenSample.OrderDetail> OrderDetails { get; set; }

        public DbSet<Net8Auto.Server.Models.RadzenSample.Order> Orders { get; set; }

        public DbSet<Net8Auto.Server.Models.RadzenSample.Product> Products { get; set; }

        protected override void ConfigureConventions(ModelConfigurationBuilder configurationBuilder)
        {
            configurationBuilder.Conventions.Add(_ => new BlankTriggerAddingConvention());
        }
    
    }
}