using System;
using System.Net;
using System.Data;
using System.Linq;
using Microsoft.Data.SqlClient;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;

using Microsoft.AspNetCore.OData.Query;
using Microsoft.AspNetCore.OData.Routing.Controllers;
using Microsoft.AspNetCore.OData.Results;
using Microsoft.AspNetCore.OData.Deltas;
using Microsoft.AspNetCore.OData.Formatter;

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Internal;

namespace Net8Auto.Server.Controllers.RadzenSample
{
    [Route("odata/RadzenSample/Orders")]
    public partial class OrdersController : ODataController
    {
        private Net8Auto.Server.Data.RadzenSampleContext context;

        public OrdersController(Net8Auto.Server.Data.RadzenSampleContext context)
        {
            this.context = context;
        }

    
        [HttpGet]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IEnumerable<Net8Auto.Server.Models.RadzenSample.Order> GetOrders()
        {
            var items = this.context.Orders.AsQueryable<Net8Auto.Server.Models.RadzenSample.Order>();
            this.OnOrdersRead(ref items);

            return items;
        }

        partial void OnOrdersRead(ref IQueryable<Net8Auto.Server.Models.RadzenSample.Order> items);

        partial void OnOrderGet(ref SingleResult<Net8Auto.Server.Models.RadzenSample.Order> item);

        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        [HttpGet("/odata/RadzenSample/Orders(Id={Id})")]
        public SingleResult<Net8Auto.Server.Models.RadzenSample.Order> GetOrder(int key)
        {
            var items = this.context.Orders.Where(i => i.Id == key);
            var result = SingleResult.Create(items);

            OnOrderGet(ref result);

            return result;
        }
        partial void OnOrderDeleted(Net8Auto.Server.Models.RadzenSample.Order item);
        partial void OnAfterOrderDeleted(Net8Auto.Server.Models.RadzenSample.Order item);

        [HttpDelete("/odata/RadzenSample/Orders(Id={Id})")]
        public IActionResult DeleteOrder(int key)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }


                var item = this.context.Orders
                    .Where(i => i.Id == key)
                    .FirstOrDefault();

                if (item == null)
                {
                    return BadRequest();
                }
                this.OnOrderDeleted(item);
                this.context.Orders.Remove(item);
                this.context.SaveChanges();
                this.OnAfterOrderDeleted(item);

                return new NoContentResult();

            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        partial void OnOrderUpdated(Net8Auto.Server.Models.RadzenSample.Order item);
        partial void OnAfterOrderUpdated(Net8Auto.Server.Models.RadzenSample.Order item);

        [HttpPut("/odata/RadzenSample/Orders(Id={Id})")]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult PutOrder(int key, [FromBody]Net8Auto.Server.Models.RadzenSample.Order item)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                if (item == null || (item.Id != key))
                {
                    return BadRequest();
                }
                this.OnOrderUpdated(item);
                this.context.Orders.Update(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.Orders.Where(i => i.Id == key);
                
                this.OnAfterOrderUpdated(item);
                return new ObjectResult(SingleResult.Create(itemToReturn));
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        [HttpPatch("/odata/RadzenSample/Orders(Id={Id})")]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult PatchOrder(int key, [FromBody]Delta<Net8Auto.Server.Models.RadzenSample.Order> patch)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                var item = this.context.Orders.Where(i => i.Id == key).FirstOrDefault();

                if (item == null)
                {
                    return BadRequest();
                }
                patch.Patch(item);

                this.OnOrderUpdated(item);
                this.context.Orders.Update(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.Orders.Where(i => i.Id == key);
                
                return new ObjectResult(SingleResult.Create(itemToReturn));
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        partial void OnOrderCreated(Net8Auto.Server.Models.RadzenSample.Order item);
        partial void OnAfterOrderCreated(Net8Auto.Server.Models.RadzenSample.Order item);

        [HttpPost]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult Post([FromBody] Net8Auto.Server.Models.RadzenSample.Order item)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                if (item == null)
                {
                    return BadRequest();
                }

                this.OnOrderCreated(item);
                this.context.Orders.Add(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.Orders.Where(i => i.Id == item.Id);

                

                this.OnAfterOrderCreated(item);

                return new ObjectResult(SingleResult.Create(itemToReturn))
                {
                    StatusCode = 201
                };
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }
    }
}
