using System;
using System.Net;
using System.Data;
using System.Linq;
using Microsoft.Data.SqlClient;
using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;

using Microsoft.AspNetCore.OData.Query;
using Microsoft.AspNetCore.OData.Routing.Controllers;
using Microsoft.AspNetCore.OData.Results;
using Microsoft.AspNetCore.OData.Deltas;
using Microsoft.AspNetCore.OData.Formatter;

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Internal;

namespace Net8Auto.Server.Controllers.RadzenSample
{
    [Route("odata/RadzenSample/OrderDetails")]
    public partial class OrderDetailsController : ODataController
    {
        private Net8Auto.Server.Data.RadzenSampleContext context;

        public OrderDetailsController(Net8Auto.Server.Data.RadzenSampleContext context)
        {
            this.context = context;
        }

    
        [HttpGet]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IEnumerable<Net8Auto.Server.Models.RadzenSample.OrderDetail> GetOrderDetails()
        {
            var items = this.context.OrderDetails.AsQueryable<Net8Auto.Server.Models.RadzenSample.OrderDetail>();
            this.OnOrderDetailsRead(ref items);

            return items;
        }

        partial void OnOrderDetailsRead(ref IQueryable<Net8Auto.Server.Models.RadzenSample.OrderDetail> items);

        partial void OnOrderDetailGet(ref SingleResult<Net8Auto.Server.Models.RadzenSample.OrderDetail> item);

        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        [HttpGet("/odata/RadzenSample/OrderDetails(Id={Id})")]
        public SingleResult<Net8Auto.Server.Models.RadzenSample.OrderDetail> GetOrderDetail(int key)
        {
            var items = this.context.OrderDetails.Where(i => i.Id == key);
            var result = SingleResult.Create(items);

            OnOrderDetailGet(ref result);

            return result;
        }
        partial void OnOrderDetailDeleted(Net8Auto.Server.Models.RadzenSample.OrderDetail item);
        partial void OnAfterOrderDetailDeleted(Net8Auto.Server.Models.RadzenSample.OrderDetail item);

        [HttpDelete("/odata/RadzenSample/OrderDetails(Id={Id})")]
        public IActionResult DeleteOrderDetail(int key)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }


                var item = this.context.OrderDetails
                    .Where(i => i.Id == key)
                    .FirstOrDefault();

                if (item == null)
                {
                    return BadRequest();
                }
                this.OnOrderDetailDeleted(item);
                this.context.OrderDetails.Remove(item);
                this.context.SaveChanges();
                this.OnAfterOrderDetailDeleted(item);

                return new NoContentResult();

            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        partial void OnOrderDetailUpdated(Net8Auto.Server.Models.RadzenSample.OrderDetail item);
        partial void OnAfterOrderDetailUpdated(Net8Auto.Server.Models.RadzenSample.OrderDetail item);

        [HttpPut("/odata/RadzenSample/OrderDetails(Id={Id})")]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult PutOrderDetail(int key, [FromBody]Net8Auto.Server.Models.RadzenSample.OrderDetail item)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                if (item == null || (item.Id != key))
                {
                    return BadRequest();
                }
                this.OnOrderDetailUpdated(item);
                this.context.OrderDetails.Update(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.OrderDetails.Where(i => i.Id == key);
                Request.QueryString = Request.QueryString.Add("$expand", "Order,Product");
                this.OnAfterOrderDetailUpdated(item);
                return new ObjectResult(SingleResult.Create(itemToReturn));
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        [HttpPatch("/odata/RadzenSample/OrderDetails(Id={Id})")]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult PatchOrderDetail(int key, [FromBody]Delta<Net8Auto.Server.Models.RadzenSample.OrderDetail> patch)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                var item = this.context.OrderDetails.Where(i => i.Id == key).FirstOrDefault();

                if (item == null)
                {
                    return BadRequest();
                }
                patch.Patch(item);

                this.OnOrderDetailUpdated(item);
                this.context.OrderDetails.Update(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.OrderDetails.Where(i => i.Id == key);
                Request.QueryString = Request.QueryString.Add("$expand", "Order,Product");
                return new ObjectResult(SingleResult.Create(itemToReturn));
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }

        partial void OnOrderDetailCreated(Net8Auto.Server.Models.RadzenSample.OrderDetail item);
        partial void OnAfterOrderDetailCreated(Net8Auto.Server.Models.RadzenSample.OrderDetail item);

        [HttpPost]
        [EnableQuery(MaxExpansionDepth=10,MaxAnyAllExpressionDepth=10,MaxNodeCount=1000)]
        public IActionResult Post([FromBody] Net8Auto.Server.Models.RadzenSample.OrderDetail item)
        {
            try
            {
                if(!ModelState.IsValid)
                {
                    return BadRequest(ModelState);
                }

                if (item == null)
                {
                    return BadRequest();
                }

                this.OnOrderDetailCreated(item);
                this.context.OrderDetails.Add(item);
                this.context.SaveChanges();

                var itemToReturn = this.context.OrderDetails.Where(i => i.Id == item.Id);

                Request.QueryString = Request.QueryString.Add("$expand", "Order,Product");

                this.OnAfterOrderDetailCreated(item);

                return new ObjectResult(SingleResult.Create(itemToReturn))
                {
                    StatusCode = 201
                };
            }
            catch(Exception ex)
            {
                ModelState.AddModelError("", ex.Message);
                return BadRequest(ModelState);
            }
        }
    }
}
