using System;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using System.Threading.Tasks;

using Net8Auto.Server.Data;

namespace Net8Auto.Server.Controllers
{
    public partial class ExportRadzenSampleController : ExportController
    {
        private readonly RadzenSampleContext context;
        private readonly RadzenSampleService service;

        public ExportRadzenSampleController(RadzenSampleContext context, RadzenSampleService service)
        {
            this.service = service;
            this.context = context;
        }

        [HttpGet("/export/RadzenSample/orderdetails/csv")]
        [HttpGet("/export/RadzenSample/orderdetails/csv(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportOrderDetailsToCSV(string fileName = null)
        {
            return ToCSV(ApplyQuery(await service.GetOrderDetails(), Request.Query, false), fileName);
        }

        [HttpGet("/export/RadzenSample/orderdetails/excel")]
        [HttpGet("/export/RadzenSample/orderdetails/excel(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportOrderDetailsToExcel(string fileName = null)
        {
            return ToExcel(ApplyQuery(await service.GetOrderDetails(), Request.Query, false), fileName);
        }

        [HttpGet("/export/RadzenSample/orders/csv")]
        [HttpGet("/export/RadzenSample/orders/csv(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportOrdersToCSV(string fileName = null)
        {
            return ToCSV(ApplyQuery(await service.GetOrders(), Request.Query, false), fileName);
        }

        [HttpGet("/export/RadzenSample/orders/excel")]
        [HttpGet("/export/RadzenSample/orders/excel(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportOrdersToExcel(string fileName = null)
        {
            return ToExcel(ApplyQuery(await service.GetOrders(), Request.Query, false), fileName);
        }

        [HttpGet("/export/RadzenSample/products/csv")]
        [HttpGet("/export/RadzenSample/products/csv(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportProductsToCSV(string fileName = null)
        {
            return ToCSV(ApplyQuery(await service.GetProducts(), Request.Query, false), fileName);
        }

        [HttpGet("/export/RadzenSample/products/excel")]
        [HttpGet("/export/RadzenSample/products/excel(fileName='{fileName}')")]
        public async Task<FileStreamResult> ExportProductsToExcel(string fileName = null)
        {
            return ToExcel(ApplyQuery(await service.GetProducts(), Request.Query, false), fileName);
        }
    }
}
