using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.JSInterop;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Radzen;
using Radzen.Blazor;

namespace Net8Auto.Client.Pages
{
    public partial class AddOrderDetail
    {
        [Inject]
        protected IJSRuntime JSRuntime { get; set; }

        [Inject]
        protected NavigationManager NavigationManager { get; set; }

        [Inject]
        protected DialogService DialogService { get; set; }

        [Inject]
        protected TooltipService TooltipService { get; set; }

        [Inject]
        protected ContextMenuService ContextMenuService { get; set; }

        [Inject]
        protected NotificationService NotificationService { get; set; }
        [Inject]
        public RadzenSampleService RadzenSampleService { get; set; }

        protected override async Task OnInitializedAsync()
        {
            orderDetail = new Net8Auto.Server.Models.RadzenSample.OrderDetail();
        }
        protected bool errorVisible;
        protected Net8Auto.Server.Models.RadzenSample.OrderDetail orderDetail;

        protected IEnumerable<Net8Auto.Server.Models.RadzenSample.Order> ordersForOrderId;

        protected IEnumerable<Net8Auto.Server.Models.RadzenSample.Product> productsForProductId;


        protected int ordersForOrderIdCount;
        protected Net8Auto.Server.Models.RadzenSample.Order ordersForOrderIdValue;
        protected async Task ordersForOrderIdLoadData(LoadDataArgs args)
        {
            try
            {
                var result = await RadzenSampleService.GetOrders(top: args.Top, skip: args.Skip, count:args.Top != null && args.Skip != null, filter: $"contains(UserName, '{(!string.IsNullOrEmpty(args.Filter) ? args.Filter : "")}')", orderby: $"{args.OrderBy}");
                ordersForOrderId = result.Value.AsODataEnumerable();
                ordersForOrderIdCount = result.Count;

            }
            catch (System.Exception ex)
            {
                NotificationService.Notify(new NotificationMessage(){ Severity = NotificationSeverity.Error, Summary = $"Error", Detail = $"Unable to load Order" });
            }
        }

        protected int productsForProductIdCount;
        protected Net8Auto.Server.Models.RadzenSample.Product productsForProductIdValue;
        protected async Task productsForProductIdLoadData(LoadDataArgs args)
        {
            try
            {
                var result = await RadzenSampleService.GetProducts(top: args.Top, skip: args.Skip, count:args.Top != null && args.Skip != null, filter: $"contains(ProductName, '{(!string.IsNullOrEmpty(args.Filter) ? args.Filter : "")}')", orderby: $"{args.OrderBy}");
                productsForProductId = result.Value.AsODataEnumerable();
                productsForProductIdCount = result.Count;

            }
            catch (System.Exception ex)
            {
                NotificationService.Notify(new NotificationMessage(){ Severity = NotificationSeverity.Error, Summary = $"Error", Detail = $"Unable to load Product" });
            }
        }
        protected async Task FormSubmit()
        {
            try
            {
                await RadzenSampleService.CreateOrderDetail(orderDetail);
                DialogService.Close(orderDetail);
            }
            catch (Exception ex)
            {
                errorVisible = true;
            }
        }

        protected async Task CancelButtonClick(MouseEventArgs args)
        {
            DialogService.Close(null);
        }
    }
}