using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.JSInterop;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Radzen;
using Radzen.Blazor;

namespace Net8Auto.Client.Pages
{
    public partial class AddOrder
    {
        [Inject]
        protected IJSRuntime JSRuntime { get; set; }

        [Inject]
        protected NavigationManager NavigationManager { get; set; }

        [Inject]
        protected DialogService DialogService { get; set; }

        [Inject]
        protected TooltipService TooltipService { get; set; }

        [Inject]
        protected ContextMenuService ContextMenuService { get; set; }

        [Inject]
        protected NotificationService NotificationService { get; set; }
        [Inject]
        public RadzenSampleService RadzenSampleService { get; set; }

        protected override async Task OnInitializedAsync()
        {
            order = new Net8Auto.Server.Models.RadzenSample.Order();
        }
        protected bool errorVisible;
        protected Net8Auto.Server.Models.RadzenSample.Order order;

        protected async Task FormSubmit()
        {
            try
            {
                await RadzenSampleService.CreateOrder(order);
                DialogService.Close(order);
            }
            catch (Exception ex)
            {
                errorVisible = true;
            }
        }

        protected async Task CancelButtonClick(MouseEventArgs args)
        {
            DialogService.Close(null);
        }
    }
}