﻿using RadzenDataGrid.NoEF.Data;
using RadzenDataGrid.NoEF.Models;

namespace RadzenDataGrid.NoEF.Services
{
    public class PaymentSvc
    {
        public async Task<SvcResult<CountableDto<List<PaymentDto>>>> GetPayments()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentDto>>(PaymentJson.Payments);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }

        public async Task<SvcResult<CountableDto<List<PaymentDto>>>> GetPaymentsNoContracts()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentDto>>(PaymentJson.PaymentsNoContracts);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }

        public async Task<SvcResult<CountableDto<List<PaymentDto>>>> GetPaymentsNoContractsNoApprDocs()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentDto>>(PaymentJson.PaymentsNoContractsNoApprDocs);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }

        public async Task<SvcResult<CountableDto<List<PaymentDto>>>> GetPaymentsNoContractsTransApprs()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentDto>>(PaymentJson.PaymentsNoContractsTransApprs);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }

        public async Task<SvcResult<CountableDto<List<PaymentDto>>>> GetPaymentsNoContractsTransApprsChildPayments()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentDto>>(PaymentJson.PaymentsNoContractsTransApprsChildPayments);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }

        public async Task<SvcResult<CountableDto<List<PaymentNoApprDto>>>> GetPaymentsNoApprovalProps()
        {
            await Task.Delay(100); // Simulate async operation

            var payments = SerializeUtil.Deserialize<List<PaymentNoApprDto>>(PaymentJson.PaymentsWithApprPropsFullData);
            var paymentsResult = new SvcResult<CountableDto<List<PaymentNoApprDto>>>
            {
                Success = true,
                Value = new CountableDto<List<PaymentNoApprDto>>
                {
                    Count = payments.Count,
                    Value = payments
                }
            };

            return paymentsResult;
        }
    }
}
