﻿using Newtonsoft.Json;

namespace RadzenDataGrid.NoEF
{
	public static class SerializeUtil
	{
		/// <summary>
		/// Serializes the specified value.
		/// </summary>
		/// <param name="value">The value.</param>
		/// <param name="settings">The json serializer settings.</param>
		/// <returns></returns>
		public static string Serialize(object value, JsonSerializerSettings settings = null)
		{
			if (value == null)
				return string.Empty;
			return JsonConvert.SerializeObject(value, settings);
		}

		/// <summary>
		/// De-serializes the specified value.
		/// </summary>
		/// <param name="value">The value.</param>
		/// <returns></returns>
		public static object Deserialize(string value)
		{
			if (value == null)
				return string.Empty;

			try
			{
				var obj = JsonConvert.DeserializeObject(value);
				return obj;
			}
			catch (Exception)
			{
				return default;
			}
		}

		/// <summary>
		/// De-serializes the specified value.
		/// </summary>
		/// <typeparam name="TValue">The type of the value.</typeparam>
		/// <param name="value">The value.</param>
		/// <returns></returns>
		public static TValue Deserialize<TValue>(string value)
		{
			if (value == null)
				return default;

			try
			{
				var obj = JsonConvert.DeserializeObject<TValue>(value);
				return obj;
			}
			catch (Exception)
			{
				return default;
			}
		}

        #region Settings
        /// <summary>
        /// Gets a setting to ignore loop references.
        /// </summary>
        /// <value>
        /// A setting to ignore loop references.
        /// </value>
        public static JsonSerializerSettings IgnoreReferenceLoopSettings
        {
            get
            {
                return new JsonSerializerSettings
                {
                    ReferenceLoopHandling = ReferenceLoopHandling.Ignore
                };
            }
        }
        #endregion
    }
}
