using Radzen;
using Radzen.Blazor;
using RadzenDataGrid.NoEF.Models;
using RadzenDataGrid.NoEF.Services;

namespace RadzenDataGrid.NoEF.Pages;

public partial class PaymentsPoorAuditCol
{
    protected RadzenDataGrid<PaymentDto> dgApprovedPayments;

    protected bool IsComponentInitialized;
    protected bool IsLoading = true;
    protected List<PaymentDto> PaymentsList;
    protected int PaymentsCount;
    protected int ApprovalId;
    protected IList<PaymentDto> Selected = null;

    protected override async Task OnInitializedAsync()
    {
        try
        {
            // Yielding here to ensure Skeleton is shown during Initialize.
            await Task.Yield();
        }
        finally
        {
            await base.OnInitializedAsync();
            IsComponentInitialized = true;
        }
    }

    protected async Task OnLoadPayments(LoadDataArgs args)
    {
        if (!IsComponentInitialized)
            return;

        await loadPaymentsAsync();
    }

    private async Task loadPaymentsAsync()
    {
        IsLoading = true;

        var paymentSvc = new PaymentSvc();
        var paymentsResult = await paymentSvc.GetPayments();
        //var paymentsResult = paymentSvc.GetPaymentsNoContracts();
        if (!paymentsResult.Success)
        {
            PaymentsCount = 0;
            PaymentsList = new List<PaymentDto>();
            IsLoading = false;
            return;
        }
        else
        {
            PaymentsCount = paymentsResult.Value.Count;
            PaymentsList = paymentsResult.Value.Value;
        }

        IsLoading = false;

        StateHasChanged();
    }
}