﻿using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models
{
	public class SvcResult
	{
		#region Constructors
		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult"/> class.
		/// Defaults <see cref="Success"/> to <c>true</c>
		/// </summary>
		public SvcResult()
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult"/> class.
		/// </summary>
		/// <param name="successful">if set to <c>true</c> then successful.</param>
		public SvcResult(bool successful) : this(successful, string.Empty)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult"/> class.
		/// </summary>
		/// <param name="successful">if set to <c>true</c> [successful].</param>
		/// <param name="msg">The MSG.</param>
		public SvcResult(bool successful, string msg) : this(successful, msg, null)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult"/> class.
		/// </summary>
		/// <param name="successful">if set to <c>true</c> then successful.</param>
		/// <param name="msg">The MSG.</param>
		/// <param name="exception">The exception.</param>
		public SvcResult(bool successful, string msg, Exception exception)
		{
			Success = successful;
			Message = msg;
			Exception = exception;
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult"/> class.
		/// </summary>
		/// <param name="successful">if set to <c>true</c> then successful.</param>
		/// <param name="msg">The MSG.</param>
		/// <param name="exception">The exception.</param>
		/// <param name="type">The type.</param>
		public SvcResult(bool successful, string msg, Exception exception, ValidationType type)
		{
			Success = successful;
			Message = msg;
			Exception = exception;
			Type = type;
		}
		#endregion

		/// <summary>
		/// Gets or sets a value indicating whether this <see cref="SvcResult"/> is successful.
		/// </summary>
		/// <value>
		///   <c>true</c> if successful; otherwise, <c>false</c>.
		/// </value>
		public bool Success { get; set; } = true;

		/// <summary>
		/// Gets or sets the exception.
		/// </summary>
		/// <value>
		/// The exception.
		/// </value>
		public Exception Exception { get; set; }

		/// <summary>
		/// Gets or sets the message.
		/// </summary>
		/// <value>
		/// The message.
		/// </value>
		public string Message { get; set; } = string.Empty;

		/// <summary>
		/// Gets or sets the type.
		/// </summary>
		/// <value>
		/// The type.
		/// </value>
		public ValidationType Type { get; set; } = ValidationType.Success;

		public override string ToString()
		{
			return $"Message: {Message}{Environment.NewLine}{(Exception == null ? string.Empty : $"Exceptions: {Exception}{Environment.NewLine}")}";
		}
	}

	public class SvcResult<T> : SvcResult
	{
		#region Constructors
		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// Defaults <see cref="SvcResult.Success"/> to <c>true</c>
		/// </summary>
		public SvcResult() : base(true, string.Empty, null)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// </summary>
		/// <param name="successful">if set to <c>true</c> [successful].</param>
		/// <param name="message">The message.</param>
		/// <param name="ex">The ex.</param>
		public SvcResult(bool successful, string message, Exception ex) : base(successful, message, ex)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// Defaults <see cref="SvcResult.Success"/> to <c>true</c>
		/// </summary>
		/// <param name="value">The value.</param>
		public SvcResult(T value) : this(value, true, string.Empty, null)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// Defaults <see cref="SvcResult.Success"/> to <c>true</c>
		/// </summary>
		/// <param name="value">The value.</param>
		/// <param name="message">The message.</param>
		public SvcResult(T value, string message) : this(value, true, message, null)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// </summary>
		/// <param name="value">The value.</param>
		/// <param name="successful">if set to <c>true</c> [successful].</param>
		/// <param name="message">The message.</param>
		public SvcResult(T value, bool successful, string message) : this(value, successful, message, null)
		{ }

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// </summary>
		/// <param name="value">The value.</param>
		/// <param name="successful">if set to <c>true</c> [successful].</param>
		/// <param name="message">The message.</param>
		/// <param name="ex">The ex.</param>
		public SvcResult(T value, bool successful, string message, Exception ex) : base(successful, message, ex)
		{
			Value = value;
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="SvcResult{T}"/> class.
		/// </summary>
		/// <param name="value"></param>
		/// <param name="successful"></param>
		/// <param name="message"></param>
		/// <param name="ex"></param>
		/// <param name="type"></param>
		public SvcResult(T value, bool successful, string message, Exception ex, ValidationType type) : base(successful, message, ex, type)
		{
			Value = value;
		}
		#endregion

		/// <summary>
		/// Gets or sets the value.
		/// </summary>
		/// <value>
		/// The value.
		/// </value>
		public T Value { get; set; }
	}
}