﻿using System.ComponentModel.DataAnnotations;
using System.Text.Json.Serialization;
using Microsoft.AspNetCore.Mvc.ModelBinding.Validation;

namespace RadzenDataGrid.NoEF.Models;

public class ProducerDto
{
    public int Id { get; set; }

    public string Name { get; set; }

    public string AddressLine1 { get; set; }

    public string AddressLine2 { get; set; }

    public int CityId => City?.Id ?? 0;

    public string EmailAddress { get; set; }

    public string PhoneNumber { get; set; }

    public string FaxNumber { get; set; }

    public bool IsActive { get; set; }

    public string CMSCode { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public CityDto City { get; set; }

    public bool IsNew { get; set; }

    [ValidateNever] // Forces the API to not validate this property
    [JsonIgnore]
    public StateProvinceDto StateProvince { get; set; }
}