﻿namespace RadzenDataGrid.NoEF.Models
{
    public class ProcurementDeliveryDto
    {
        public int Id { get; set; }

        public string DivisionCode { get; set; }

        public string LocationCode { get; set; }

        public int HeadCount { get; set; }

        public int OffTruckWeight { get; set; }

        public DateTime DeliveredDate { get; set; }

        public string CattleGenderCode { get; set; }

        public int ProducerId { get; set; }

        public int OriginCityId { get; set; }

        public int? LocationId { get; set; }

        public string Comments { get; set; }

        public bool IsApproved { get; set; }

        public int ContractId { get; set; }

        public int ContractDetailId { get; set; }

        public int ContractDetailDeliveryId { get; set; }

        public string CreatedBy { get; set; }

        public DateTime CreatedDate { get; set; }

        public string ChangedBy { get; set; }

        public DateTime ChangedDate { get; set; }

        public int AvgWeight => HeadCount == 0 ? 0 : OffTruckWeight / HeadCount;

        // Navigation Properties

        public CattleGenderDto CattleGender { get; set; }

        public ProducerDto Producer { get; set; }

        public CityDto Origin { get; set; }

        public LocationDto Location { get; set; }

        public ContractDto Contract { get; set; }

        public ContractDetailDto ContractDetail { get; set; }

        public ContractDetailDeliveryDto ContractDetailDelivery { get; set; }
    }
}