﻿using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class ProcurementApprovalDto : OriginDto
{
    public int Id { get; set; }

    public int ProcurementDeliveryId { get; set; }

    public ProcurementApprovalStatus StatusCode => Status?.Id ?? ProcurementApprovalStatus.Pending;

    public string DivisionCode { get; set; }

    public string LocationCode { get; set; }

    public int HeadCount { get; set; }

    public int OffTruckWeight { get; set; }

    public string CattleGenderCode => CattleGender?.Id ?? string.Empty;

    public CattleBackground CattleBackgroundCode => CattleBackground?.Id ?? Enums.CattleBackground.GrowYard;

    public string CattleBreedCode => CattleBreed?.Id ?? string.Empty;

    public string CattleScoreCode => CattleScore?.Id ?? string.Empty;

    public DateTime DeliveredDate { get; set; }

    public string Comments { get; set; }

    public int ProducerId { get; set; }

    public int OriginCityId { get; set; }

    public int? LocationId { get; set; }

    public int PayeeVendorId { get; set; }

    public int ContractId { get; set; }

    public int ContractDetailId { get; set; }

    public int ContractDetailDeliveryId { get; set; }

    public int? PaymentId { get; set; }

    public bool IsLotted { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public bool IsWashingtonLocation { get; set; }

    public int AvgWeight => HeadCount == 0 ? 0 : OffTruckWeight / HeadCount;

    public string SharePointFolder => $"{LocationCode}/{CreatedDate.Year}/{Id}";

    // Navigation Properties

    public ProcurementApprovalStatusDto Status { get; set; }

    public List<ProcurementApprovalDocumentDto> Documents { get; set; } = new();

    public ProcurementDeliveryDto Delivery { get; set; }

    public CattleGenderDto CattleGender { get; set; }

    public CattleBackgroundDto CattleBackground { get; set; }

    public CattleBreedDto CattleBreed { get; set; }

    public CattleScoreDto CattleScore { get; set; }

    public ProducerDto Producer { get; set; }

    public CityDto Origin { get; set; }

    public LocationDto Location { get; set; }
        
    public VendorDto PayeeVendor { get; set; }

    public ContractDto Contract { get; set; }

    public ContractDetailDto ContractDetail { get; set; }

    public ContractDetailDeliveryDto ContractDetailDelivery { get; set; }

    public PaymentDto Payment { get; set; }
}