﻿using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models
{
    public class ProcurementApprovalDocumentDto
    {
        public int Id { get; set; }

        public int ProcurementApprovalId { get; set; }

        public ProcurementDocumentType ProcurementDocumentTypeCode { get; set; }

        public string MetadataJson { get; set; }

        public string CreatedBy { get; set; }

        public DateTime CreatedDate { get; set; }

        public string ChangedBy { get; set; }

        public DateTime ChangedDate { get; set; }

        public ProcurementDocumentTypeDto DocumentType { get; set; }

        private ProcurementBrandDocTypeDto _brandDocument;

        public ProcurementBrandDocTypeDto BrandDocument
        {
            get
            {
                if (_brandDocument == null)
                    _brandDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.Brand ? SerializeUtil.Deserialize<ProcurementBrandDocTypeDto>(MetadataJson) : null;
                return _brandDocument;
            }
        }

        private ProcurementHealthCertDocTypeDto _healthCertificateDocument;

        public ProcurementHealthCertDocTypeDto HealthCertificateDocument
        {
            get
            {
                if (_healthCertificateDocument == null)
                    _healthCertificateDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.HealthCertificate ? SerializeUtil.Deserialize<ProcurementHealthCertDocTypeDto>(MetadataJson) : null;
                return _healthCertificateDocument;
            }
        }

        private ProcurementWashingtonPermitDocTypeDto _washingtonPermitDocument;

        public ProcurementWashingtonPermitDocTypeDto WashingtonPermitDocument
        {
            get
            {
                if (_washingtonPermitDocument == null)
                    _washingtonPermitDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.WashingtonPermit ? SerializeUtil.Deserialize<ProcurementWashingtonPermitDocTypeDto>(MetadataJson) : null;
                return _washingtonPermitDocument;
            }
        }

        private ProcurementLT30TransferDocTypeDto _lt30TransferDocument;

        public ProcurementLT30TransferDocTypeDto LT30TransferDocument
        {
            get
            {
                if (_lt30TransferDocument == null)
                    _lt30TransferDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.LT30Transfer ? SerializeUtil.Deserialize<ProcurementLT30TransferDocTypeDto>(MetadataJson) : null;
                return _lt30TransferDocument;
            }
        }

        private ProcurementEIDManifestDocTypeDto _eidManifestDocument;

        public ProcurementEIDManifestDocTypeDto EIDManifestDocument
        {
            get
            {
                if (_eidManifestDocument == null)
                    _eidManifestDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.EIDManifest ? SerializeUtil.Deserialize<ProcurementEIDManifestDocTypeDto>(MetadataJson) : null;
                return _eidManifestDocument;
            }
        }

        private ProcurementCanadianManifestDocTypeDto _canadianManifestDocument;

        public ProcurementCanadianManifestDocTypeDto CanadianManifestDocument
        {
            get
            {
                if (_canadianManifestDocument == null)
                    _canadianManifestDocument = ProcurementDocumentTypeCode == ProcurementDocumentType.CanadianManifest ? SerializeUtil.Deserialize<ProcurementCanadianManifestDocTypeDto>(MetadataJson) : null;
                return _canadianManifestDocument;
            }
        }

        /// <summary>
        /// Updates the documents <see cref="MetadataJson"/>.
        /// </summary>
        public void UpdateMetaDataJson()
        {
            switch (DocumentType.Id)
            {
                case ProcurementDocumentType.Brand:
                    MetadataJson = SerializeUtil.Serialize(BrandDocument);
                    break;
                case ProcurementDocumentType.HealthCertificate:
                    MetadataJson = SerializeUtil.Serialize(HealthCertificateDocument);
                    break;
                case ProcurementDocumentType.WashingtonPermit:
                    MetadataJson = SerializeUtil.Serialize(WashingtonPermitDocument);
                    break;
                case ProcurementDocumentType.CanadianManifest:
                    MetadataJson = SerializeUtil.Serialize(CanadianManifestDocument);
                    break;
                case ProcurementDocumentType.EIDManifest:
                    MetadataJson = SerializeUtil.Serialize(EIDManifestDocument);
                    break;
                case ProcurementDocumentType.LT30Transfer:
                    MetadataJson = SerializeUtil.Serialize(LT30TransferDocument);
                    break;
            }
        }
    }
}