﻿namespace RadzenDataGrid.NoEF.Models;

public class PaymentTransactionDto
{
    public long Id { get; set; }

    public long PaymentId { get; set; }

    public string PaymentTransactionCodeId { get; set; }

    public decimal Amount { get; set; }

    public string Description { get; set; } = string.Empty;

    public decimal VendorId { get; set; }

    public bool IsFinalTransaction { get; set; }

    public long? OriginalPaymentId { get; set; }

    public string DivisionCode { get; set; }

    public string LocationCode { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    /// <summary>
    /// UI property to control if the transaction can be removed.
    /// </summary>
    /// <value>
    ///   <c>false</c> if it can be removed; otherwise, <c>true</c>.
    /// </value>
    public bool IsReadOnly { get; set; }

    /// <summary>
    /// This controls which transactions are used to calculate the net payment.
    /// This is defaulted to true.
    /// e.g. CAT and CATP transactions are the actual cattle payments and are not an adjustment.
    /// </summary>
    /// <value>
    ///   <c>true</c> if this is an adjustment; otherwise, <c>false</c>.
    /// </value>
    public bool IsAdjustment { get; set; } = true;

    public PaymentTransactionCodeDto TransactionCode { get; set; }

    public int ContractId { get; set; }

    public int ContractDetailId { get; set; }

    public VendorDto Vendor { get; set; }
}