﻿using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class PaymentNoApprDto
{
    public long Id { get; set; }

    public string InvoiceNumber { get; set; }

    public DateTime InvoiceDate { get; set; }

    public int InvoiceNetPayWeight { get; set; }

    public int NetAvgBaseWeight { get; set; }

    public decimal OffTruckShrink { get; set; }

    public decimal DollarsPerCWT { get; set; }

    public decimal GrossTotalPayment { get; set; }

    // NOTE: Do not use NetTotalPayment in any calculations outside of Commission payments.
    // This amount represents different things for different scenarios e.g. Approving a payment, Creating DAX interface records, etc.
    // The net amount should be calculated based on the specific scenario.
    public decimal NetTotalPayment { get; set; }

    public decimal? FinalDollarsPerCWT { get; set; }

    public PaymentType PaymentType { get; set; }

    public PaymentStatus Status { get; set; }

    public bool IsFinalPayment { get; set; }

    public string ApprBy { get; set; }

    public DateTime? ApprDate { get; set; }

    public string ApprComments { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public decimal PreviousDownPaymentAmount { get; set; }

    public decimal RemainingDownPaymentAmount { get; set; }

    public string GenderDisplay => Approvals.FirstOrDefault()?.CattleGender?.DisplayName ?? string.Empty;

    public decimal TotalAdjustmentAmount => Transactions.Where(t => t.IsAdjustment).Sum(adj => adj.Amount);

    public decimal InvoiceNetPayCWT => (decimal) InvoiceNetPayWeight / 100;

    public string ContractSummary { get; set; }

    public string PaymentSummary => $"{HeadCount} {GenderDisplay} {NetAvgBaseWeight}# @ ${DollarsPerCWT} CWT";

    public decimal PremiumPricePerCWT { get; set; }

    public int OffTruckWeight { get; set; }

    public int BaseWeight { get; set; }

    public int HeadCount { get; set; }

    public string DivisionCode { get; set; }

    public string LocationCode { get; set; }

    public string DAXInterfaceId { get; set; }

    public List<PaymentDto> ChildPayments { get; set; } = new(2);

    public List<int> ApprIds => Approvals.Select(a => a.Id).ToList();

    public List<DateTime> DeliveredDates => Approvals.Select(a => a.DeliveredDate).Distinct().OrderBy(d => d).ToList();

    public List<PaymentTransactionDto> Transactions { get; set; } = new(5);

    #region Properties used for calculating final payments and adjustments
    public decimal OrigGrossTotalPayment { get; set; }

    public decimal PercentOfTotalWeight { get; set; }

    public decimal AdjustedDollarsBasedOnPercentOfTotalWeight { get; set; }

    public decimal AdjustedPaymentAmount { get; set; }
    #endregion

    public int ContractId { get; set; }

    public int ContractDetailId { get; set; }

    public ContractDto Contract { get; set; }

    public ContractDetailDto ContractDetail { get; set; }

    public VendorDto Vendor { get; set; }

    public List<ProcurementApprovalDto> Approvals { get; set; } = new();
}