﻿using System.ComponentModel.DataAnnotations;
using System.Text.Json.Serialization;
using Microsoft.AspNetCore.Mvc.ModelBinding.Validation;

namespace RadzenDataGrid.NoEF.Models;

public class LocationDto
{
    public int Id { get; set; }

    public string Name { get; set; }

    public string NameCityState => $"{Name}, {City?.Name}, {City?.StateProvinceCode}";

    public int CityId => City?.Id ?? 0;

    public bool IsActive { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public CityDto City { get; set; }

    public bool IsNew { get; set; }

    [JsonIgnore]
    public StateProvinceDto StateProvince { get; set; }
}