﻿using System.ComponentModel.DataAnnotations;

namespace RadzenDataGrid.NoEF.Models;

public class ContractOwnerDto
{
    public int Id { get; set; }

    public int ContractId { get; set; }

    public int VendorId => Owner?.Id ?? 0;

    /// <summary>
    /// Gets or sets the ownership percent decimal value.
    /// <remarks>
    /// This gets set to [ <see cref="OwnershipPctPercentage"/> / 100 ] when mapped to a ContractOwner by AutoMapper
    /// </remarks>
    /// </summary>
    /// <value>
    /// The ownership percent decimal value.
    /// </value>
    public decimal OwnershipPct { get; set; }

    /// <summary>
    /// Gets or sets the ownership percentage.
    /// <remarks>
    /// Use this in the UI. This value will override <see cref="OwnershipPct"/>
    /// </remarks>
    /// </summary>
    /// <value>
    /// The ownership percentage.
    /// </value>
    public decimal OwnershipPctPercentage { get; set; }

    public string FinancingTypeCode => FinancingType?.Id;

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public VendorDto Owner { get; set; }

    public FinancingTypeDto FinancingType { get; set; }
}