﻿using System.ComponentModel.DataAnnotations;
using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class ContractDto
{
    public int Id { get; set; }

    public ContractType ContractTypeCode => ContractType?.Id ?? Enums.ContractType.None;

    public ContractStatus StatusCode => Status?.Id ?? ContractStatus.New;

    public CattleBreedCategory CattleBreedCategoryCode => CattleBreedCategory?.Id ?? Enums.CattleBreedCategory.Other;

    public int CompanyRepId => CompanyRep?.Id ?? 0;

    public int PayeeVendorId => Payee?.Id ?? 0;

    private bool _isBasis;

    public bool IsBasis
    {
        get { return _isBasis; }
        set
        {
            _isBasis = value;
            Details.ForEach(d => d.IsBasisContract = _isBasis);
        }
    }

    public string IsBasisDisplay => IsBasis ? "Yes" : "No";

    public string OutsideRefNumber { get; set; } = string.Empty;

    public int? OutsideBuyerVendorId => OutsideBuyer?.Id;

    public decimal CommissionPerCWT { get; set; } = 0;

    public int HeadCount { get; set; }

    public decimal TotalDownPayment => DownPayments.Sum(dp => dp.TotalAmount);

    public bool CanDelete { get; set; }

    public DateTime? StartDeliveryDate { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    private ContractTypeDto _contractType;

    public ContractTypeDto ContractType
    {
        get { return _contractType; }
        set
        {
            _contractType = value;
            Details.ForEach(d => d.ContractTypeCode = _contractType?.Id ?? Enums.ContractType.None);
        }
    }

    public ContractStatusDto Status { get; set; }

    private CattleBreedCategoryDto _cattleBreedCategory;

    public CattleBreedCategoryDto CattleBreedCategory
    {
        get { return _cattleBreedCategory; }
        set
        {
            _cattleBreedCategory = value;
            Details.ForEach(d => d.CattleBreedCategory = _cattleBreedCategory?.Id ?? Enums.CattleBreedCategory.Other);
        }
    }

    public CompanyRepDto CompanyRep { get; set; }

    public VendorDto Payee { get; set; }
		
    public VendorDto OutsideBuyer { get; set; }

    private List<ContractDetailDto> _details = new();

    public List<ContractDetailDto> Details
    {
        get { return _details; }
        set
        {
            _details = value;
            foreach (var detail in _details)
            {
                detail.ContractTypeCode = ContractTypeCode;
                detail.CattleBreedCategory = CattleBreedCategoryCode;
                detail.IsBasisContract = IsBasis;
            }
        }
    }

    public List<ContractDownPaymentDto> DownPayments { get; set; } = new();

    public List<ContractOwnerDto> Owners { get; set; } = new();

    public List<ContractDetailPricingDto> Pricings { get; set; } = new();
		
    public List<ContractDetailDeliveryDto> Deliveries { get; set; } = new();
}