﻿namespace RadzenDataGrid.NoEF.Models;

public class ContractDownPaymentDto
{
    public int Id { get; set; }

    public int ContractId { get; set; }

    public int PayeeVendorId { get; set; }

    public decimal PricePerHead { get; set; }

    public int HeadCount { get; set; }

    public bool IsPosted { get; set; }

    public string DAXInterfaceId { get; set; }

    public decimal TotalAmount => PricePerHead * HeadCount;

    public string AmountPerHeadDisplay => $"{HeadCount:N0}hd @ {PricePerHead:C}";

    public bool CanDelete => !IsPosted;

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public VendorDto Payee { get; set; }
}