﻿using System.Text;
using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class ContractDetailProjectionDto
{
    public int Id { get; set; }

    public int ContractId { get; set; }

    public int DetailId { get; set; }

    public int DetailSequenceNumber { get; set; }

    public ProjectionType ProjectionTypeCode { get; set; }

    public DateTime AvgInDate { get; set; }

    public string FinishingYardDivisionCode { get; set; }

    public string FinishingYardLocationCode { get; set; }

    public DateTime ProjectionDate { get; set; }

    public int HeadCount { get; set; }

    public int AvgPayWeightIn { get; set; }

    public int TotalPayWeightIn { get; set; }

    public decimal CattleCostCWT { get; set; }

    public decimal TotalCattleCost { get; set; }

    public decimal InterestOnCattle { get; set; }

    public decimal InterestOnFeedAndMed { get; set; }

    public decimal InterestOnYardage { get; set; }

    public decimal FeedCostPerHead { get; set; }

    public decimal FeedCostOfGainCWT { get; set; }

    public decimal RationPricePerTon { get; set; }

    public decimal ConversionFactor { get; set; }

    public decimal VetMedPerHead { get; set; }

    public decimal MiscPerHead { get; set; }

    public decimal TotalYardageCost { get; set; }

    public decimal DeathLossRailerPct { get; set; } = 1M;

    public decimal TotalCostOfGain { get; set; }

    public decimal CostOfGainCWT { get; set; }

    public int DaysOnFeed { get; set; }

    public decimal AvgDailyGain { get; set; }

    public int ProjectedAvgWeightOut { get; set; }

    public DateTime ProjectedOutDate { get; set; }

    public decimal FOBBreakeven { get; set; }

    public decimal DLVDBreakeven { get; set; }

    public decimal PurchaseCostPerHead { get; set; }

    public decimal TotalFeedCost { get; set; }

    public int GainPerHead { get; set; }

    public decimal TotalBrandsAndDuesCost { get; set; }
		
    public decimal TotalMedicineCost { get; set; }

    public decimal DeathLossCost { get; set; }

    public decimal TotalMiscCost { get; set; }

    public bool IsCurrent { get; set; }

    public bool IsNew { get; set; }

    public decimal FreightRateInCWT { get; set; }

    public decimal TotalFreightCostIn => Math.Round(AvgPayWeightIn * (FreightRateInCWT / 100), 2, MidpointRounding.AwayFromZero);

    public decimal YearlingToFatFreightInCWT { get; set; }

    public decimal TotalFreightInCostYearlingToFat => Math.Round(AvgPayWeightIn * (YearlingToFatFreightInCWT / 100), 2, MidpointRounding.AwayFromZero);

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public ContractProjectionTypeDto ProjectionType { get; set; }

    // Constants from database

    public decimal InterestRatePct { get; set; }

    public decimal BrandsAndDues { get; set; }

    public decimal YardagePerHeadPerDay { get; set; }

    public decimal FreightOutCWT { get; set; }
}