﻿using System.ComponentModel.DataAnnotations;
using Newtonsoft.Json;
using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class ContractDetailDto
{
    public int Id { get; set; }

    public int SequenceNumber { get; set; }

    public int ContractId { get; set; }

    public string DivisionCode { get; set; }

    public string LocationCode { get; set; }

    public int ProducerId => Producer?.Id ?? 0;

    public int CityId => City?.Id ?? 0;

    public int? LocationId => Location?.Id;

    public DateTime StartDeliveryDate { get; set; }

    public DateTime? EndDeliveryDate { get; set; }

    public int HeadCount { get; set; }

    public int BaseWeight { get; set; }

    public decimal FreightRate { get; set; }

    public FreightType FreightTypeCode => FreightType?.Id ?? Enums.FreightType.DLVD;

    public decimal BasisAmount { get; set; }

    public string BasisMonth { get; set; }

    public decimal AvgStrikePrice { get; set; }

    public SlideType SlideTypeCode => SlideType?.Id ?? Enums.SlideType.NoSlide;

    public decimal Slide1 { get; set; }

    public decimal Slide2 { get; set; }

    public int WeightStop { get; set; }

    public bool HasFinalSlideAdjustment { get; set; }

    public string CattleGenderCode => CattleGender?.Id;

    public string CattleAgeCode => CattleAge?.Id;

    public string CattleScoreCode => CattleScore?.Id;

    public string CattleBreedCode => CattleBreed?.Id;

    public CattleBackground CattleBackgroundCode => CattleBackground?.Id ?? Enums.CattleBackground.HayFed;

    public CattleWeighCondition CattleWeighConditionCode => CattleWeighCondition?.Id ?? Enums.CattleWeighCondition.Yard;

    public string CattleProgramCode => CattleProgram?.Id;

    // Default every detail will need a projection - Cattle Category and Cattle Backgrounds drive if it's not required.
    public bool ProjectionRequired { get; set; } = true;

    /// <summary>
    /// Gets or sets the shrink percent decimal value.
    /// <remarks>
    /// This gets set to [ <see cref="ShrinkPctPercentage"/> / 100 ] when mapped to a ContractDetail by AutoMapper
    /// </remarks>
    /// </summary>
    /// <value>
    /// The shrink percent decimal value.
    /// </value>
    public decimal ShrinkPct { get; set; }

    /// <summary>
    /// Gets or sets the shrink percentage.
    /// <remarks>
    /// Use this in the UI. This value will override <see cref="ShrinkPct"/>
    /// </remarks>
    /// </summary>
    /// <value>
    /// The shrink percentage.
    /// </value>
    public decimal ShrinkPctPercentage { get; set; }

    public string Comments { get; set; } = string.Empty;

    public bool? PerformPregCheck { get; set; }

    public bool? CaptureDNA { get; set; }

    public string BullName { get; set; }

    public string TagNumbers { get; set; }

    public decimal PremiumPrice { get; set; }

    public bool IsNew { get; set; }

    public bool IsEditing { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public List<ContractDetailPricingDto> Pricings { get; set; } = new();

    public List<ContractDetailDeliveryDto> Deliveries { get; set; } = new();

    public List<ContractDetailProjectionDto> Projections { get; set; } = new();

    public ProducerDto Producer { get; set; }

    public LocationDto Location { get; set; }

    public CityDto City { get; set; }

    public SlideTypeDto SlideType { get; set; }

    public CattleGenderDto CattleGender { get; set; }

    public CattleAgeDto CattleAge { get; set; }

    public CattleScoreDto CattleScore { get; set; }

    public CattleBreedDto CattleBreed { get; set; }

    public CattleBackgroundDto CattleBackground { get; set; }

    public CattleWeighConditionDto CattleWeighCondition { get; set; }

    public CattleProgramDto CattleProgram { get; set; }

    public FreightTypeDto FreightType { get; set; }

    // These properties are only used for validation

    [JsonIgnore]
    public StateProvinceDto StateProvince { get; set; }

    // Properties for the RequiredIf attributes

    public ContractType ContractTypeCode { get; set; }

    public CattleBreedCategory CattleBreedCategory { get; set; }

    public bool IsBasisContract { get; set; }
}