﻿using Newtonsoft.Json;
using RadzenDataGrid.NoEF.Enums;

namespace RadzenDataGrid.NoEF.Models;

public class ContractDetailDeliveryDto
{
    public int Id { get; set; }

    public int SequenceNumber { get; set; }

    public int? TruckOrderStopNumber { get; set; }

    public int ContractId { get; set; }

    public int DetailId { get; set; }

    public int DetailSequenceNumber { get; set; }

    public ContractDetailDeliveryStatus StatusCode => Status?.Id ?? ContractDetailDeliveryStatus.Preliminary;

    public DateTime? DeliveryDate { get; set; }

    public int HeadCount { get; set; }

    public int DeliveredHeadCount { get; set; }

    public string CattleGenderCode => CattleGender?.Id;

    public int BaseWeight { get; set; }

    public int CityId => City?.Id ?? 0;

    public string CityStateCountry => City?.CityStateCountry ?? string.Empty;

    public string DivisionCode { get; set; }

    public string LocationCode { get; set; }

    public string Destination => $"{DivisionCode}-{LocationCode}";

    public FreightType FreightTypeCode => FreightType?.Id ?? Enums.FreightType.DLVD;

    public string Comments { get; set; } = string.Empty;

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }

    public ContractDetailDeliveryStatusDto Status { get; set; }

    public CattleGenderDto CattleGender { get; set; }

    public CityDto City { get; set; }

    public FreightTypeDto FreightType { get; set; }

    // These properties are only used for validation

    [JsonIgnore]
    public StateProvinceDto StateProvince { get; set; }
}