﻿namespace RadzenDataGrid.NoEF.Models;

public class CityDto
{
    public int Id { get; set; }

    public string Name { get; set; }

    public string StateProvinceCode { get; set; }

    public string StateProvince { get; set; }

    public string CountryCode { get; set; }

    public string Country { get; set; }

    public string CityStateCountry => $"{Name}, {StateProvinceCode} {CountryCode}";

    public string StateProvinceWithCountryCode => $"{StateProvince}, {CountryCode}";

    public string County { get; set; }

    /// <summary>
    /// Gets or sets the zip codes.
    /// <remarks>
    /// Multiple zip codes are separated by a /
    /// </remarks>
    /// </summary>
    /// <value>
    /// The zip codes.
    /// </value>
    public string ZipCodes { get; set; }

    public string CityType { get; set; }

    public decimal Latitude { get; set; }

    public decimal Longitude { get; set; }

    /// <summary>
    /// Gets or sets the area codes.
    /// <remarks>
    /// Multiple area codes are separated by a /
    /// </remarks>
    /// </summary>
    /// <value>
    /// The area codes.
    /// </value>
    public string AreaCodes { get; set; }

    public bool IsActive { get; set; }

    public bool IsNew { get; set; }

    public string CMSCode { get; set; }

    public string CreatedBy { get; set; }

    public DateTime CreatedDate { get; set; }

    public string ChangedBy { get; set; }

    public DateTime ChangedDate { get; set; }
}