﻿namespace RadzenDataGrid.NoEF.Enums
{
	/// <summary>
	/// The Procurement Contract Types
	/// </summary>
	public enum ContractType
	{
		/// <summary>
		/// Used to denote a brand new Contract before it has a type.
		/// </summary>
		None,

		/// <summary>
		/// Contract
		/// We use this type to denote there is a down payment associated with the cattle.
		/// We are advancing them money before the cattle ship, then deducting that amount from the total payment after the cattle ship.
		/// </summary>
		CO,

		/// <summary>
		/// Pasture Lot
		/// We use these to input Company owned cattle that will be transferring from NW locations to AB Yards.
		/// </summary>
		PL,

		/// <summary>
		/// Purchase Order
		/// Simple straight up purchase of cattle.
		/// </summary>
		PO,

		/// <summary>
		/// Request for Pen Space
		/// This contract is used when a customer is retaining ownership at our feed yard.
		/// </summary>
		RQ,

		/// <summary>
		/// Sale Yard
		/// These contracts have little info on them.
		/// When we buy from a sale yard we are not shrinking or sliding cattle.
		/// The contract is strictly used to get cattle on the delivery list and provide a head count and weight to the yard.
		/// $ are not being generated or determined off of the contract.
		/// </summary>
		SY
	}
}