using BlazorApp.Components;
using BlazorApp.Components.AtRadzen;
using BlazorApp.Data;
using Microsoft.AspNetCore.Components;
using Microsoft.Extensions.DependencyInjection;
using Radzen;
using Radzen.Blazor;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.
builder.Services.AddRazorComponents()
    .AddInteractiveServerComponents().AddCircuitOptions(options => options.DetailedErrors = true);

builder.Services.AddRadzenComponents();


var activator = new RadzenComponentActivator();
activator.Override(typeof(RadzenDataGrid<>), typeof(RadzenGridTemplate<>));
builder.Services.AddSingleton<IComponentActivator>(activator);


builder.Services.AddScoped<MovieService>();

var app = builder.Build();



// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error", createScopeForErrors: true);
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.UseHttpsRedirection();

app.UseStaticFiles();
app.UseAntiforgery();

app.MapRazorComponents<App>()
    .AddInteractiveServerRenderMode();

app.Run();
