﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace BlazorApp.Models
{
    [Table("Movie")]
    public class Movie
    {
        [Key]
        public int Id { get; set; }
        [Display(Name = "Рейтинг"), DisplayFormat(DataFormatString = "{0:N2}")]
        public double Rating { get; set; }
        [Display(Name = "Название")]
        public string Title { get; set; }

        [Display(Name = "Дата выхода"), DisplayFormat(DataFormatString = "{0:d}")]
        [Column(TypeName = "date")]
        [DataType(DataType.Date)]
        public DateTime ReleaseDate { get; set; }
        [Display(Name = "Жанр")]
        public string Genre { get; set; }

        [Column(TypeName = "money")]
        [Display(Name = "Цена"), DisplayFormat(DataFormatString = "{0:C}")]
        public decimal Price { get; set; }

        [NotMapped]
        public bool Selected { get; set; }
    }
}
