using BlazorApp.Models;
using System.Collections.Generic;

namespace BlazorApp.Data
{
    public class MovieService
    {

        public Task<IQueryable<Movie>> GetMoviesAsync(int count)
        {
            var genres = new[]
            {
                "Absurdist","Action","Adventure","Comedy","Crime","Drama","Fantasy","Historical",
                "Historical fiction","Horror","Magical realism","Mystery","Paranoid Fiction","Philosophical",
                "Political","Romance","Saga","Satire","Science fiction","Social","Speculative","Thriller",
                "Urban","Western"
            };

            var startDate = new DateTime(1971, 6, 26);
            var maxDays = (new DateTime(2018, 11, 6) - startDate).Days;
            var rnd = new Random();
            List<Movie> movies = [];
            for (int i = 1; i <= count; i++)
            {
                var genre = genres[rnd.Next(0, genres.Length)];
                movies.Add(new Movie
                {
                    Id = i,
                    Rating = rnd.NextDouble() * 100,
                    //Genre = genre,
                    Genre = rnd.Next(2) == 1 ? genre : string.Empty,
                    //Title = $"{genre} movie  {i}",
                    Title = rnd.Next(2) == 1 ? $"{genre} movie  {i}" : string.Empty,
                    ReleaseDate = startDate.AddDays(rnd.Next(0, maxDays)),
                    Price = (decimal)(rnd.NextDouble() * 10)
                });
            }
            return Task.FromResult(movies.AsQueryable());
        }



    }
}
